(function($){

	if ( undefined == window.astra ) {
		return;
	}

	astraSingleProductAjax = {

		/**
		 * Quick view AJAX add to cart
		 */
		quick_view_enable       : astra.shop_quick_view_enable || false,

		/**
		 * Single product AJAX add to cart
		 */
		ajax_add_to_cart_enable : astra.single_product_ajax_add_to_cart || false,
	
		/**
		 * Init
		 */
		init: function()
		{
			this._bind();
		},
		
		/**
		 * Binds events
		 */
		_bind: function()
		{
			if ( astraSingleProductAjax.ajax_add_to_cart_enable ) {
				$( document ).on( 'click', 'body.single-product .product:not(.product-type-external) button.single_add_to_cart_button, #sticky-add-to-cart .single_add_to_cart_button', astraSingleProductAjax._processAjaxRequest );
			}

			if ( astraSingleProductAjax.quick_view_enable ) {
				$( document.body ).on( 'click', '#ast-quick-view-content .product:not(.product-type-external) button.single_add_to_cart_button', astraSingleProductAjax._processAjaxRequest );
			}

			$( document.body ).on( 'added_to_cart', astraSingleProductAjax._updateButton );

			$( "form.variations_form" ).on( 'woocommerce_variation_has_changed', astraSingleProductAjax._updateSaleBadge );

		},

		/**
		 * Process add to cart AJAX request
		 *
		 * @param  object e Event object.
		 * @return void
		 */
		_processAjaxRequest: function( e )
		{
			e.preventDefault();

			var $form = $(this).closest('form');

			// If the form inputs are invalid
			if( ! $form[0].checkValidity() ) {
				$form[0].reportValidity();
				return false;
			}

			var $thisbutton  = $( this ),
			product_id   = $form.find('input[name="add-to-cart"]').val() || $form.find('input[name="product_id"]').val() || $(this).val() || '',
			variation_id = $form.find('input[name="variation_id"]').val() || '';

			if ( $form.hasClass('variations_form') && ! variation_id ) {
				$form[0].reportValidity();
				return false;
			}

			if( $thisbutton.hasClass( 'disabled' ) ) {
				return;
			}

			// Add loading to the button.
			$thisbutton.removeClass( 'added' );
			$thisbutton.addClass( 'loading' );

			// Set Quantity.
			// For grouped product quantity should be array instead of single value
			var quantity = $form.find('input[name="quantity"]').val();
			if( $form.find('.woocommerce-grouped-product-list-item' ).length){
				var quantities = $form.find('input.qty'),
					quantity   = [];

				$.each(quantities, function(index, val) {
					var name = $( this ).attr( 'name' );
					name = name.replace('quantity[','').replace(']','');
					name = parseInt( name );

					if( $( this ).val() ) {
						quantity[ name ] = $( this ).val();
					}
				});
			}

			// Create FormData object for better file and custom field handling
			var formData = new FormData($form[0]);

			var cartFormData = $form.serialize();

			// Add required parameters
			formData.append('action', 'astra_add_cart_single_product');
			formData.append('add-to-cart', product_id);
			if (variation_id) {
				formData.append('variation_id', variation_id);
			}

			// Include quantity data
			if (quantity) {
				if (Array.isArray(quantity)) {
					$.each(quantity, function (name, value) {
						formData.append('quantity[' + name + ']', value);
					});
				} else {
					formData.append('quantity', quantity);
				}
			}

			// Process the AJAX
			$.ajax({
				url: astra.ajax_url,
				type:'POST',
				data:formData,
				contentType: false,
				processData: false,
				success:function(results) {
					if(!results || 0 === results.length) {
						location.reload();
						return false;
					}

					// Trigger event so themes can refresh other areas.
					$( document.body ).trigger( 'wc_fragment_refresh' );
					$( document.body ).trigger( 'added_to_cart', [ results.fragments, results.cart_hash, $thisbutton ] );

					if( astra.is_single_product ) {
						const slideInCart = $( '#astra-mobile-cart-drawer' );

						if( 'slide_in_cart' === astra.add_to_cart_options_single && slideInCart ) {
							$( document.body ).one( 'wc_fragments_refreshed', function() {
								slideInCart.addClass( 'active' );
								$( 'html' ).addClass( 'ast-mobile-cart-active' );
							});
						}

						if( 'redirect_cart_page' === astra.add_to_cart_options_single ) {
							window.open( astra.cart_url ,"_self");
						}

						if( 'redirect_checkout_page' === astra.add_to_cart_options_single ) {
							window.open( astra.checkout_url ,"_self");
						}

						if( 'default' === astra.add_to_cart_options_single ) {

							if ( typeof wc_add_to_cart_params === 'undefined' ) {
								return;
							}

							// Redirect to cart option.
							if ( wc_add_to_cart_params.cart_redirect_after_add === 'yes' ) {
								window.location = wc_add_to_cart_params.cart_url;
								return;
							}
						}
					}
				},
				error: function (xhr, status, error) {
					console.error('Add to cart error:', error);
					$thisbutton.removeClass('loading');

					// Show error to user
					if (xhr.responseJSON && xhr.responseJSON.error) {
						alert(xhr.responseJSON.error);
					} else {
						alert('Could not add product to cart. Please try again.');
					}
				}
			});
		},

		/**
		 * Update cart page elements after add to cart events.
		 */
		_updateButton: function( e, fragments, cart_hash, button )
		{
			button = typeof button === 'undefined' ? false : button;

			if ( $( 'button.single_add_to_cart_button' ).length ) {

				$( button ).removeClass( 'loading' );
				$( button ).addClass( 'added' );

				// View cart text.
				if ( ! astra.is_cart && $(button).parent().find( '.added_to_cart' ).length === 0 ) {
					$(button).after( ' <a href="' + astra.cart_url + '" class="added_to_cart wc-forward" title="' +
						astra.view_cart + '">' + astra.view_cart + '</a>' );
				}

				$( document.body ).trigger( 'wc_cart_button_updated', [ button ] );
			}

		},

		/**
		 * Update sale badge percentage when product variation is switched.
		 */
		_updateSaleBadge: function( e ) 
		{
			var $form = $(this);
			var selected_variation = $form.find('.variation_id').val();
			
			if( '' != selected_variation ) {
				var sale_badge = $form.closest( '.product-type-variable').find( 'span.onsale' );
				var sale_notification = sale_badge.data( 'notification' );

				if( 'sale-percentage' == sale_notification ) {
					var sale_data = sale_badge.data('sale');

					if( 'undefined' != typeof sale_data[selected_variation] ) {
						var sale_percentage_text = sale_badge.data('sale-per-text');
						sale_percentage_text = sale_percentage_text.replace( '[value]', sale_data[selected_variation] );
						sale_badge.text( sale_percentage_text );
					}
				}
			}
		}

	};

	/**
	 * Initialization
	 */
	$(function(){
		astraSingleProductAjax.init();
	});

})(jQuery);