<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Google\Site_Kit_Dependencies\Google\Service;

use Google\Site_Kit_Dependencies\Google\Client;
/**
 * Service definition for GoogleAnalyticsAdminV1alpha (v1alpha).
 *
 * <p>
 * Manage properties in Google Analytics. Warning: Creating multiple Customer
 * Applications, Accounts, or Projects to simulate or act as a single Customer
 * Application, Account, or Project (respectively) or to circumvent Service-
 * specific usage limits or quotas is a direct violation of Google Cloud
 * Platform Terms of Service as well as Google APIs Terms of Service. These
 * actions can result in immediate termination of your GCP project(s) without
 * any warning.</p>
 *
 * <p>
 * For more information about this service, see the API
 * <a href="http://code.google.com/apis/analytics/docs/mgmt/home.html" target="_blank">Documentation</a>
 * </p>
 *
 * @author Google, Inc.
 */
class GoogleAnalyticsAdminV1alpha extends \Google\Site_Kit_Dependencies\Google\Service
{
    /** Edit Google Analytics management entities. */
    const ANALYTICS_EDIT = "https://www.googleapis.com/auth/analytics.edit";
    /** Manage Google Analytics Account users by email address. */
    const ANALYTICS_MANAGE_USERS = "https://www.googleapis.com/auth/analytics.manage.users";
    /** View Google Analytics user permissions. */
    const ANALYTICS_MANAGE_USERS_READONLY = "https://www.googleapis.com/auth/analytics.manage.users.readonly";
    /** See and download your Google Analytics data. */
    const ANALYTICS_READONLY = "https://www.googleapis.com/auth/analytics.readonly";
    public $accountSummaries;
    public $accounts;
    public $accounts_accessBindings;
    public $properties;
    public $properties_accessBindings;
    public $properties_adSenseLinks;
    public $properties_audiences;
    public $properties_bigQueryLinks;
    public $properties_calculatedMetrics;
    public $properties_channelGroups;
    public $properties_conversionEvents;
    public $properties_customDimensions;
    public $properties_customMetrics;
    public $properties_dataStreams;
    public $properties_dataStreams_eventCreateRules;
    public $properties_dataStreams_eventEditRules;
    public $properties_dataStreams_measurementProtocolSecrets;
    public $properties_dataStreams_sKAdNetworkConversionValueSchema;
    public $properties_displayVideo360AdvertiserLinkProposals;
    public $properties_displayVideo360AdvertiserLinks;
    public $properties_expandedDataSets;
    public $properties_firebaseLinks;
    public $properties_googleAdsLinks;
    public $properties_keyEvents;
    public $properties_reportingDataAnnotations;
    public $properties_rollupPropertySourceLinks;
    public $properties_searchAds360Links;
    public $properties_subpropertyEventFilters;
    public $properties_subpropertySyncConfigs;
    public $rootUrlTemplate;
    /**
     * Constructs the internal representation of the GoogleAnalyticsAdminV1alpha service.
     *
     * @param Client|array $clientOrConfig The client used to deliver requests, or a
     *                                     config array to pass to a new Client instance.
     * @param string $rootUrl The root URL used for requests to the service.
     */
    public function __construct($clientOrConfig = [], $rootUrl = null)
    {
        parent::__construct($clientOrConfig);
        $this->rootUrl = $rootUrl ?: 'https://analyticsadmin.googleapis.com/';
        $this->rootUrlTemplate = $rootUrl ?: 'https://analyticsadmin.UNIVERSE_DOMAIN/';
        $this->servicePath = '';
        $this->batchPath = 'batch';
        $this->version = 'v1alpha';
        $this->serviceName = 'analyticsadmin';
        $this->accountSummaries = new \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource\AccountSummaries($this, $this->serviceName, 'accountSummaries', ['methods' => ['list' => ['path' => 'v1alpha/accountSummaries', 'httpMethod' => 'GET', 'parameters' => ['pageSize' => ['location' => 'query', 'type' => 'integer'], 'pageToken' => ['location' => 'query', 'type' => 'string']]]]]);
        $this->accounts = new \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource\Accounts($this, $this->serviceName, 'accounts', ['methods' => ['delete' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'DELETE', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'get' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'getDataSharingSettings' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'list' => ['path' => 'v1alpha/accounts', 'httpMethod' => 'GET', 'parameters' => ['pageSize' => ['location' => 'query', 'type' => 'integer'], 'pageToken' => ['location' => 'query', 'type' => 'string'], 'showDeleted' => ['location' => 'query', 'type' => 'boolean']]], 'patch' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'PATCH', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'updateMask' => ['location' => 'query', 'type' => 'string']]], 'provisionAccountTicket' => ['path' => 'v1alpha/accounts:provisionAccountTicket', 'httpMethod' => 'POST', 'parameters' => []], 'runAccessReport' => ['path' => 'v1alpha/{+entity}:runAccessReport', 'httpMethod' => 'POST', 'parameters' => ['entity' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'searchChangeHistoryEvents' => ['path' => 'v1alpha/{+account}:searchChangeHistoryEvents', 'httpMethod' => 'POST', 'parameters' => ['account' => ['location' => 'path', 'type' => 'string', 'required' => \true]]]]]);
        $this->accounts_accessBindings = new \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource\AccountsAccessBindings($this, $this->serviceName, 'accessBindings', ['methods' => ['batchCreate' => ['path' => 'v1alpha/{+parent}/accessBindings:batchCreate', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'batchDelete' => ['path' => 'v1alpha/{+parent}/accessBindings:batchDelete', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'batchGet' => ['path' => 'v1alpha/{+parent}/accessBindings:batchGet', 'httpMethod' => 'GET', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'names' => ['location' => 'query', 'type' => 'string', 'repeated' => \true]]], 'batchUpdate' => ['path' => 'v1alpha/{+parent}/accessBindings:batchUpdate', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'create' => ['path' => 'v1alpha/{+parent}/accessBindings', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'delete' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'DELETE', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'get' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'list' => ['path' => 'v1alpha/{+parent}/accessBindings', 'httpMethod' => 'GET', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'pageSize' => ['location' => 'query', 'type' => 'integer'], 'pageToken' => ['location' => 'query', 'type' => 'string']]], 'patch' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'PATCH', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]]]]);
        $this->properties = new \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource\Properties($this, $this->serviceName, 'properties', ['methods' => ['acknowledgeUserDataCollection' => ['path' => 'v1alpha/{+property}:acknowledgeUserDataCollection', 'httpMethod' => 'POST', 'parameters' => ['property' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'create' => ['path' => 'v1alpha/properties', 'httpMethod' => 'POST', 'parameters' => []], 'createRollupProperty' => ['path' => 'v1alpha/properties:createRollupProperty', 'httpMethod' => 'POST', 'parameters' => []], 'delete' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'DELETE', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'get' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'getAttributionSettings' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'getDataRetentionSettings' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'getGoogleSignalsSettings' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'getReportingIdentitySettings' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'list' => ['path' => 'v1alpha/properties', 'httpMethod' => 'GET', 'parameters' => ['filter' => ['location' => 'query', 'type' => 'string'], 'pageSize' => ['location' => 'query', 'type' => 'integer'], 'pageToken' => ['location' => 'query', 'type' => 'string'], 'showDeleted' => ['location' => 'query', 'type' => 'boolean']]], 'patch' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'PATCH', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'updateMask' => ['location' => 'query', 'type' => 'string']]], 'provisionSubproperty' => ['path' => 'v1alpha/properties:provisionSubproperty', 'httpMethod' => 'POST', 'parameters' => []], 'runAccessReport' => ['path' => 'v1alpha/{+entity}:runAccessReport', 'httpMethod' => 'POST', 'parameters' => ['entity' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'submitUserDeletion' => ['path' => 'v1alpha/{+name}:submitUserDeletion', 'httpMethod' => 'POST', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'updateAttributionSettings' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'PATCH', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'updateMask' => ['location' => 'query', 'type' => 'string']]], 'updateDataRetentionSettings' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'PATCH', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'updateMask' => ['location' => 'query', 'type' => 'string']]], 'updateGoogleSignalsSettings' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'PATCH', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'updateMask' => ['location' => 'query', 'type' => 'string']]]]]);
        $this->properties_accessBindings = new \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource\PropertiesAccessBindings($this, $this->serviceName, 'accessBindings', ['methods' => ['batchCreate' => ['path' => 'v1alpha/{+parent}/accessBindings:batchCreate', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'batchDelete' => ['path' => 'v1alpha/{+parent}/accessBindings:batchDelete', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'batchGet' => ['path' => 'v1alpha/{+parent}/accessBindings:batchGet', 'httpMethod' => 'GET', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'names' => ['location' => 'query', 'type' => 'string', 'repeated' => \true]]], 'batchUpdate' => ['path' => 'v1alpha/{+parent}/accessBindings:batchUpdate', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'create' => ['path' => 'v1alpha/{+parent}/accessBindings', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'delete' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'DELETE', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'get' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'list' => ['path' => 'v1alpha/{+parent}/accessBindings', 'httpMethod' => 'GET', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'pageSize' => ['location' => 'query', 'type' => 'integer'], 'pageToken' => ['location' => 'query', 'type' => 'string']]], 'patch' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'PATCH', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]]]]);
        $this->properties_adSenseLinks = new \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource\PropertiesAdSenseLinks($this, $this->serviceName, 'adSenseLinks', ['methods' => ['create' => ['path' => 'v1alpha/{+parent}/adSenseLinks', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'delete' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'DELETE', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'get' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'list' => ['path' => 'v1alpha/{+parent}/adSenseLinks', 'httpMethod' => 'GET', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'pageSize' => ['location' => 'query', 'type' => 'integer'], 'pageToken' => ['location' => 'query', 'type' => 'string']]]]]);
        $this->properties_audiences = new \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource\PropertiesAudiences($this, $this->serviceName, 'audiences', ['methods' => ['archive' => ['path' => 'v1alpha/{+name}:archive', 'httpMethod' => 'POST', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'create' => ['path' => 'v1alpha/{+parent}/audiences', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'get' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'list' => ['path' => 'v1alpha/{+parent}/audiences', 'httpMethod' => 'GET', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'pageSize' => ['location' => 'query', 'type' => 'integer'], 'pageToken' => ['location' => 'query', 'type' => 'string']]], 'patch' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'PATCH', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'updateMask' => ['location' => 'query', 'type' => 'string']]]]]);
        $this->properties_bigQueryLinks = new \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource\PropertiesBigQueryLinks($this, $this->serviceName, 'bigQueryLinks', ['methods' => ['create' => ['path' => 'v1alpha/{+parent}/bigQueryLinks', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'delete' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'DELETE', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'get' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'list' => ['path' => 'v1alpha/{+parent}/bigQueryLinks', 'httpMethod' => 'GET', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'pageSize' => ['location' => 'query', 'type' => 'integer'], 'pageToken' => ['location' => 'query', 'type' => 'string']]], 'patch' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'PATCH', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'updateMask' => ['location' => 'query', 'type' => 'string']]]]]);
        $this->properties_calculatedMetrics = new \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource\PropertiesCalculatedMetrics($this, $this->serviceName, 'calculatedMetrics', ['methods' => ['create' => ['path' => 'v1alpha/{+parent}/calculatedMetrics', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'calculatedMetricId' => ['location' => 'query', 'type' => 'string']]], 'delete' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'DELETE', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'get' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'list' => ['path' => 'v1alpha/{+parent}/calculatedMetrics', 'httpMethod' => 'GET', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'pageSize' => ['location' => 'query', 'type' => 'integer'], 'pageToken' => ['location' => 'query', 'type' => 'string']]], 'patch' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'PATCH', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'updateMask' => ['location' => 'query', 'type' => 'string']]]]]);
        $this->properties_channelGroups = new \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource\PropertiesChannelGroups($this, $this->serviceName, 'channelGroups', ['methods' => ['create' => ['path' => 'v1alpha/{+parent}/channelGroups', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'delete' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'DELETE', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'get' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'list' => ['path' => 'v1alpha/{+parent}/channelGroups', 'httpMethod' => 'GET', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'pageSize' => ['location' => 'query', 'type' => 'integer'], 'pageToken' => ['location' => 'query', 'type' => 'string']]], 'patch' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'PATCH', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'updateMask' => ['location' => 'query', 'type' => 'string']]]]]);
        $this->properties_conversionEvents = new \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource\PropertiesConversionEvents($this, $this->serviceName, 'conversionEvents', ['methods' => ['create' => ['path' => 'v1alpha/{+parent}/conversionEvents', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'delete' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'DELETE', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'get' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'list' => ['path' => 'v1alpha/{+parent}/conversionEvents', 'httpMethod' => 'GET', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'pageSize' => ['location' => 'query', 'type' => 'integer'], 'pageToken' => ['location' => 'query', 'type' => 'string']]], 'patch' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'PATCH', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'updateMask' => ['location' => 'query', 'type' => 'string']]]]]);
        $this->properties_customDimensions = new \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource\PropertiesCustomDimensions($this, $this->serviceName, 'customDimensions', ['methods' => ['archive' => ['path' => 'v1alpha/{+name}:archive', 'httpMethod' => 'POST', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'create' => ['path' => 'v1alpha/{+parent}/customDimensions', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'get' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'list' => ['path' => 'v1alpha/{+parent}/customDimensions', 'httpMethod' => 'GET', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'pageSize' => ['location' => 'query', 'type' => 'integer'], 'pageToken' => ['location' => 'query', 'type' => 'string']]], 'patch' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'PATCH', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'updateMask' => ['location' => 'query', 'type' => 'string']]]]]);
        $this->properties_customMetrics = new \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource\PropertiesCustomMetrics($this, $this->serviceName, 'customMetrics', ['methods' => ['archive' => ['path' => 'v1alpha/{+name}:archive', 'httpMethod' => 'POST', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'create' => ['path' => 'v1alpha/{+parent}/customMetrics', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'get' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'list' => ['path' => 'v1alpha/{+parent}/customMetrics', 'httpMethod' => 'GET', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'pageSize' => ['location' => 'query', 'type' => 'integer'], 'pageToken' => ['location' => 'query', 'type' => 'string']]], 'patch' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'PATCH', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'updateMask' => ['location' => 'query', 'type' => 'string']]]]]);
        $this->properties_dataStreams = new \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource\PropertiesDataStreams($this, $this->serviceName, 'dataStreams', ['methods' => ['create' => ['path' => 'v1alpha/{+parent}/dataStreams', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'delete' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'DELETE', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'get' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'getDataRedactionSettings' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'getEnhancedMeasurementSettings' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'getGlobalSiteTag' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'list' => ['path' => 'v1alpha/{+parent}/dataStreams', 'httpMethod' => 'GET', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'pageSize' => ['location' => 'query', 'type' => 'integer'], 'pageToken' => ['location' => 'query', 'type' => 'string']]], 'patch' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'PATCH', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'updateMask' => ['location' => 'query', 'type' => 'string']]], 'updateDataRedactionSettings' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'PATCH', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'updateMask' => ['location' => 'query', 'type' => 'string']]], 'updateEnhancedMeasurementSettings' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'PATCH', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'updateMask' => ['location' => 'query', 'type' => 'string']]]]]);
        $this->properties_dataStreams_eventCreateRules = new \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource\PropertiesDataStreamsEventCreateRules($this, $this->serviceName, 'eventCreateRules', ['methods' => ['create' => ['path' => 'v1alpha/{+parent}/eventCreateRules', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'delete' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'DELETE', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'get' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'list' => ['path' => 'v1alpha/{+parent}/eventCreateRules', 'httpMethod' => 'GET', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'pageSize' => ['location' => 'query', 'type' => 'integer'], 'pageToken' => ['location' => 'query', 'type' => 'string']]], 'patch' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'PATCH', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'updateMask' => ['location' => 'query', 'type' => 'string']]]]]);
        $this->properties_dataStreams_eventEditRules = new \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource\PropertiesDataStreamsEventEditRules($this, $this->serviceName, 'eventEditRules', ['methods' => ['create' => ['path' => 'v1alpha/{+parent}/eventEditRules', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'delete' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'DELETE', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'get' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'list' => ['path' => 'v1alpha/{+parent}/eventEditRules', 'httpMethod' => 'GET', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'pageSize' => ['location' => 'query', 'type' => 'integer'], 'pageToken' => ['location' => 'query', 'type' => 'string']]], 'patch' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'PATCH', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'updateMask' => ['location' => 'query', 'type' => 'string']]], 'reorder' => ['path' => 'v1alpha/{+parent}/eventEditRules:reorder', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]]]]);
        $this->properties_dataStreams_measurementProtocolSecrets = new \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource\PropertiesDataStreamsMeasurementProtocolSecrets($this, $this->serviceName, 'measurementProtocolSecrets', ['methods' => ['create' => ['path' => 'v1alpha/{+parent}/measurementProtocolSecrets', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'delete' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'DELETE', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'get' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'list' => ['path' => 'v1alpha/{+parent}/measurementProtocolSecrets', 'httpMethod' => 'GET', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'pageSize' => ['location' => 'query', 'type' => 'integer'], 'pageToken' => ['location' => 'query', 'type' => 'string']]], 'patch' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'PATCH', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'updateMask' => ['location' => 'query', 'type' => 'string']]]]]);
        $this->properties_dataStreams_sKAdNetworkConversionValueSchema = new \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource\PropertiesDataStreamsSKAdNetworkConversionValueSchema($this, $this->serviceName, 'sKAdNetworkConversionValueSchema', ['methods' => ['create' => ['path' => 'v1alpha/{+parent}/sKAdNetworkConversionValueSchema', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'delete' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'DELETE', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'get' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'list' => ['path' => 'v1alpha/{+parent}/sKAdNetworkConversionValueSchema', 'httpMethod' => 'GET', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'pageSize' => ['location' => 'query', 'type' => 'integer'], 'pageToken' => ['location' => 'query', 'type' => 'string']]], 'patch' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'PATCH', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'updateMask' => ['location' => 'query', 'type' => 'string']]]]]);
        $this->properties_displayVideo360AdvertiserLinkProposals = new \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource\PropertiesDisplayVideo360AdvertiserLinkProposals($this, $this->serviceName, 'displayVideo360AdvertiserLinkProposals', ['methods' => ['approve' => ['path' => 'v1alpha/{+name}:approve', 'httpMethod' => 'POST', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'cancel' => ['path' => 'v1alpha/{+name}:cancel', 'httpMethod' => 'POST', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'create' => ['path' => 'v1alpha/{+parent}/displayVideo360AdvertiserLinkProposals', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'delete' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'DELETE', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'get' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'list' => ['path' => 'v1alpha/{+parent}/displayVideo360AdvertiserLinkProposals', 'httpMethod' => 'GET', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'pageSize' => ['location' => 'query', 'type' => 'integer'], 'pageToken' => ['location' => 'query', 'type' => 'string']]]]]);
        $this->properties_displayVideo360AdvertiserLinks = new \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource\PropertiesDisplayVideo360AdvertiserLinks($this, $this->serviceName, 'displayVideo360AdvertiserLinks', ['methods' => ['create' => ['path' => 'v1alpha/{+parent}/displayVideo360AdvertiserLinks', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'delete' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'DELETE', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'get' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'list' => ['path' => 'v1alpha/{+parent}/displayVideo360AdvertiserLinks', 'httpMethod' => 'GET', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'pageSize' => ['location' => 'query', 'type' => 'integer'], 'pageToken' => ['location' => 'query', 'type' => 'string']]], 'patch' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'PATCH', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'updateMask' => ['location' => 'query', 'type' => 'string']]]]]);
        $this->properties_expandedDataSets = new \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource\PropertiesExpandedDataSets($this, $this->serviceName, 'expandedDataSets', ['methods' => ['create' => ['path' => 'v1alpha/{+parent}/expandedDataSets', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'delete' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'DELETE', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'get' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'list' => ['path' => 'v1alpha/{+parent}/expandedDataSets', 'httpMethod' => 'GET', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'pageSize' => ['location' => 'query', 'type' => 'integer'], 'pageToken' => ['location' => 'query', 'type' => 'string']]], 'patch' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'PATCH', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'updateMask' => ['location' => 'query', 'type' => 'string']]]]]);
        $this->properties_firebaseLinks = new \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource\PropertiesFirebaseLinks($this, $this->serviceName, 'firebaseLinks', ['methods' => ['create' => ['path' => 'v1alpha/{+parent}/firebaseLinks', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'delete' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'DELETE', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'list' => ['path' => 'v1alpha/{+parent}/firebaseLinks', 'httpMethod' => 'GET', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'pageSize' => ['location' => 'query', 'type' => 'integer'], 'pageToken' => ['location' => 'query', 'type' => 'string']]]]]);
        $this->properties_googleAdsLinks = new \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource\PropertiesGoogleAdsLinks($this, $this->serviceName, 'googleAdsLinks', ['methods' => ['create' => ['path' => 'v1alpha/{+parent}/googleAdsLinks', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'delete' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'DELETE', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'list' => ['path' => 'v1alpha/{+parent}/googleAdsLinks', 'httpMethod' => 'GET', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'pageSize' => ['location' => 'query', 'type' => 'integer'], 'pageToken' => ['location' => 'query', 'type' => 'string']]], 'patch' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'PATCH', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'updateMask' => ['location' => 'query', 'type' => 'string']]]]]);
        $this->properties_keyEvents = new \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource\PropertiesKeyEvents($this, $this->serviceName, 'keyEvents', ['methods' => ['create' => ['path' => 'v1alpha/{+parent}/keyEvents', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'delete' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'DELETE', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'get' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'list' => ['path' => 'v1alpha/{+parent}/keyEvents', 'httpMethod' => 'GET', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'pageSize' => ['location' => 'query', 'type' => 'integer'], 'pageToken' => ['location' => 'query', 'type' => 'string']]], 'patch' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'PATCH', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'updateMask' => ['location' => 'query', 'type' => 'string']]]]]);
        $this->properties_reportingDataAnnotations = new \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource\PropertiesReportingDataAnnotations($this, $this->serviceName, 'reportingDataAnnotations', ['methods' => ['create' => ['path' => 'v1alpha/{+parent}/reportingDataAnnotations', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'delete' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'DELETE', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'get' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'list' => ['path' => 'v1alpha/{+parent}/reportingDataAnnotations', 'httpMethod' => 'GET', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'filter' => ['location' => 'query', 'type' => 'string'], 'pageSize' => ['location' => 'query', 'type' => 'integer'], 'pageToken' => ['location' => 'query', 'type' => 'string']]], 'patch' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'PATCH', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'updateMask' => ['location' => 'query', 'type' => 'string']]]]]);
        $this->properties_rollupPropertySourceLinks = new \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource\PropertiesRollupPropertySourceLinks($this, $this->serviceName, 'rollupPropertySourceLinks', ['methods' => ['create' => ['path' => 'v1alpha/{+parent}/rollupPropertySourceLinks', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'delete' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'DELETE', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'get' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'list' => ['path' => 'v1alpha/{+parent}/rollupPropertySourceLinks', 'httpMethod' => 'GET', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'pageSize' => ['location' => 'query', 'type' => 'integer'], 'pageToken' => ['location' => 'query', 'type' => 'string']]]]]);
        $this->properties_searchAds360Links = new \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource\PropertiesSearchAds360Links($this, $this->serviceName, 'searchAds360Links', ['methods' => ['create' => ['path' => 'v1alpha/{+parent}/searchAds360Links', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'delete' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'DELETE', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'get' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'list' => ['path' => 'v1alpha/{+parent}/searchAds360Links', 'httpMethod' => 'GET', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'pageSize' => ['location' => 'query', 'type' => 'integer'], 'pageToken' => ['location' => 'query', 'type' => 'string']]], 'patch' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'PATCH', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'updateMask' => ['location' => 'query', 'type' => 'string']]]]]);
        $this->properties_subpropertyEventFilters = new \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource\PropertiesSubpropertyEventFilters($this, $this->serviceName, 'subpropertyEventFilters', ['methods' => ['create' => ['path' => 'v1alpha/{+parent}/subpropertyEventFilters', 'httpMethod' => 'POST', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'delete' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'DELETE', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'get' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'list' => ['path' => 'v1alpha/{+parent}/subpropertyEventFilters', 'httpMethod' => 'GET', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'pageSize' => ['location' => 'query', 'type' => 'integer'], 'pageToken' => ['location' => 'query', 'type' => 'string']]], 'patch' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'PATCH', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'updateMask' => ['location' => 'query', 'type' => 'string']]]]]);
        $this->properties_subpropertySyncConfigs = new \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\Resource\PropertiesSubpropertySyncConfigs($this, $this->serviceName, 'subpropertySyncConfigs', ['methods' => ['get' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'GET', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true]]], 'list' => ['path' => 'v1alpha/{+parent}/subpropertySyncConfigs', 'httpMethod' => 'GET', 'parameters' => ['parent' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'pageSize' => ['location' => 'query', 'type' => 'integer'], 'pageToken' => ['location' => 'query', 'type' => 'string']]], 'patch' => ['path' => 'v1alpha/{+name}', 'httpMethod' => 'PATCH', 'parameters' => ['name' => ['location' => 'path', 'type' => 'string', 'required' => \true], 'updateMask' => ['location' => 'query', 'type' => 'string']]]]]);
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(\Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha::class, 'Google\\Site_Kit_Dependencies\\Google_Service_GoogleAnalyticsAdminV1alpha');
